package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.iot.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.JobStatus
  ): zio.aws.iot.model.JobStatus = value match {
    case software.amazon.awssdk.services.iot.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.JobStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.iot.model.JobStatus.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.iot.model.JobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.iot.model.JobStatus.DELETION_IN_PROGRESS =>
      val r = DELETION_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.JobStatus =
      software.amazon.awssdk.services.iot.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.iot.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.JobStatus =
      software.amazon.awssdk.services.iot.model.JobStatus.IN_PROGRESS
  }
  case object CANCELED extends zio.aws.iot.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.JobStatus =
      software.amazon.awssdk.services.iot.model.JobStatus.CANCELED
  }
  case object COMPLETED extends zio.aws.iot.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.JobStatus =
      software.amazon.awssdk.services.iot.model.JobStatus.COMPLETED
  }
  case object DELETION_IN_PROGRESS extends zio.aws.iot.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.JobStatus =
      software.amazon.awssdk.services.iot.model.JobStatus.DELETION_IN_PROGRESS
  }
}
