package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  ThingGroupId,
  JobArn,
  DateType,
  JobId,
  BooleanWrapperObject
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class JobSummary(
    jobArn: Optional[JobArn] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    thingGroupId: Optional[ThingGroupId] = Optional.Absent,
    targetSelection: Optional[zio.aws.iot.model.TargetSelection] =
      Optional.Absent,
    status: Optional[zio.aws.iot.model.JobStatus] = Optional.Absent,
    createdAt: Optional[DateType] = Optional.Absent,
    lastUpdatedAt: Optional[DateType] = Optional.Absent,
    completedAt: Optional[DateType] = Optional.Absent,
    isConcurrent: Optional[BooleanWrapperObject] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.JobSummary = {
    import JobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobSummary
      .builder()
      .optionallyWith(
        jobArn.map(value => JobArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        thingGroupId.map(value => ThingGroupId.unwrap(value): java.lang.String)
      )(_.thingGroupId)
      .optionallyWith(targetSelection.map(value => value.unwrap))(
        _.targetSelection
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        completedAt.map(value => DateType.unwrap(value): Instant)
      )(_.completedAt)
      .optionallyWith(
        isConcurrent.map(value =>
          BooleanWrapperObject.unwrap(value): java.lang.Boolean
        )
      )(_.isConcurrent)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobSummary.ReadOnly =
    zio.aws.iot.model.JobSummary.wrap(buildAwsValue())
}
object JobSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.JobSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobSummary = zio.aws.iot.model.JobSummary(
      jobArn.map(value => value),
      jobId.map(value => value),
      thingGroupId.map(value => value),
      targetSelection.map(value => value),
      status.map(value => value),
      createdAt.map(value => value),
      lastUpdatedAt.map(value => value),
      completedAt.map(value => value),
      isConcurrent.map(value => value)
    )
    def jobArn: Optional[JobArn]
    def jobId: Optional[JobId]
    def thingGroupId: Optional[ThingGroupId]
    def targetSelection: Optional[zio.aws.iot.model.TargetSelection]
    def status: Optional[zio.aws.iot.model.JobStatus]
    def createdAt: Optional[DateType]
    def lastUpdatedAt: Optional[DateType]
    def completedAt: Optional[DateType]
    def isConcurrent: Optional[BooleanWrapperObject]
    def getJobArn: ZIO[Any, AwsError, JobArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getThingGroupId: ZIO[Any, AwsError, ThingGroupId] =
      AwsError.unwrapOptionField("thingGroupId", thingGroupId)
    def getTargetSelection
        : ZIO[Any, AwsError, zio.aws.iot.model.TargetSelection] =
      AwsError.unwrapOptionField("targetSelection", targetSelection)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCompletedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("completedAt", completedAt)
    def getIsConcurrent: ZIO[Any, AwsError, BooleanWrapperObject] =
      AwsError.unwrapOptionField("isConcurrent", isConcurrent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobSummary
  ) extends zio.aws.iot.model.JobSummary.ReadOnly {
    override val jobArn: Optional[JobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => zio.aws.iot.model.primitives.JobArn(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.iot.model.primitives.JobId(value))
    override val thingGroupId: Optional[ThingGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.thingGroupId())
      .map(value => zio.aws.iot.model.primitives.ThingGroupId(value))
    override val targetSelection: Optional[zio.aws.iot.model.TargetSelection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetSelection())
        .map(value => zio.aws.iot.model.TargetSelection.wrap(value))
    override val status: Optional[zio.aws.iot.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.JobStatus.wrap(value))
    override val createdAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastUpdatedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val completedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.completedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val isConcurrent: Optional[BooleanWrapperObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isConcurrent())
        .map(value => zio.aws.iot.model.primitives.BooleanWrapperObject(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobSummary
  ): zio.aws.iot.model.JobSummary.ReadOnly = new Wrapper(impl)
}
