package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PrivateKey, PublicKey}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KeyPair(
    publicKey: Optional[PublicKey] = Optional.Absent,
    privateKey: Optional[PrivateKey] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.KeyPair = {
    import KeyPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.KeyPair
      .builder()
      .optionallyWith(
        publicKey.map(value => PublicKey.unwrap(value): java.lang.String)
      )(_.publicKey)
      .optionallyWith(
        privateKey.map(value => PrivateKey.unwrap(value): java.lang.String)
      )(_.privateKey)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.KeyPair.ReadOnly =
    zio.aws.iot.model.KeyPair.wrap(buildAwsValue())
}
object KeyPair {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.KeyPair] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.KeyPair = zio.aws.iot.model
      .KeyPair(publicKey.map(value => value), privateKey.map(value => value))
    def publicKey: Optional[PublicKey]
    def privateKey: Optional[PrivateKey]
    def getPublicKey: ZIO[Any, AwsError, PublicKey] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getPrivateKey: ZIO[Any, AwsError, PrivateKey] =
      AwsError.unwrapOptionField("privateKey", privateKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.KeyPair
  ) extends zio.aws.iot.model.KeyPair.ReadOnly {
    override val publicKey: Optional[PublicKey] = zio.aws.core.internal
      .optionalFromNullable(impl.publicKey())
      .map(value => zio.aws.iot.model.primitives.PublicKey(value))
    override val privateKey: Optional[PrivateKey] = zio.aws.core.internal
      .optionalFromNullable(impl.privateKey())
      .map(value => zio.aws.iot.model.primitives.PrivateKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.KeyPair
  ): zio.aws.iot.model.KeyPair.ReadOnly = new Wrapper(impl)
}
