package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PartitionKey, StreamName, AwsArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KinesisAction(
    roleArn: AwsArn,
    streamName: StreamName,
    partitionKey: Optional[PartitionKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.KinesisAction = {
    import KinesisAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.KinesisAction
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .optionallyWith(
        partitionKey.map(value => PartitionKey.unwrap(value): java.lang.String)
      )(_.partitionKey)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.KinesisAction.ReadOnly =
    zio.aws.iot.model.KinesisAction.wrap(buildAwsValue())
}
object KinesisAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.KinesisAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.KinesisAction = zio.aws.iot.model
      .KinesisAction(roleArn, streamName, partitionKey.map(value => value))
    def roleArn: AwsArn
    def streamName: StreamName
    def partitionKey: Optional[PartitionKey]
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getPartitionKey: ZIO[Any, AwsError, PartitionKey] =
      AwsError.unwrapOptionField("partitionKey", partitionKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.KinesisAction
  ) extends zio.aws.iot.model.KinesisAction.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val streamName: StreamName =
      zio.aws.iot.model.primitives.StreamName(impl.streamName())
    override val partitionKey: Optional[PartitionKey] = zio.aws.core.internal
      .optionalFromNullable(impl.partitionKey())
      .map(value => zio.aws.iot.model.primitives.PartitionKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.KinesisAction
  ): zio.aws.iot.model.KinesisAction.ReadOnly = new Wrapper(impl)
}
