package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.FunctionArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LambdaAction(functionArn: FunctionArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.LambdaAction = {
    import LambdaAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.LambdaAction
      .builder()
      .functionArn(FunctionArn.unwrap(functionArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.LambdaAction.ReadOnly =
    zio.aws.iot.model.LambdaAction.wrap(buildAwsValue())
}
object LambdaAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.LambdaAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.LambdaAction =
      zio.aws.iot.model.LambdaAction(functionArn)
    def functionArn: FunctionArn
    def getFunctionArn: ZIO[Any, Nothing, FunctionArn] =
      ZIO.succeed(functionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.LambdaAction
  ) extends zio.aws.iot.model.LambdaAction.ReadOnly {
    override val functionArn: FunctionArn =
      zio.aws.iot.model.primitives.FunctionArn(impl.functionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.LambdaAction
  ): zio.aws.iot.model.LambdaAction.ReadOnly = new Wrapper(impl)
}
