package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DeviceDefenderThingName,
  NextToken,
  ListSuppressedAlerts,
  SecurityProfileName,
  MaxResults
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListActiveViolationsRequest(
    thingName: Optional[DeviceDefenderThingName] = Optional.Absent,
    securityProfileName: Optional[SecurityProfileName] = Optional.Absent,
    behaviorCriteriaType: Optional[zio.aws.iot.model.BehaviorCriteriaType] =
      Optional.Absent,
    listSuppressedAlerts: Optional[ListSuppressedAlerts] = Optional.Absent,
    verificationState: Optional[zio.aws.iot.model.VerificationState] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest = {
    import ListActiveViolationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest
      .builder()
      .optionallyWith(
        thingName.map(value =>
          DeviceDefenderThingName.unwrap(value): java.lang.String
        )
      )(_.thingName)
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(behaviorCriteriaType.map(value => value.unwrap))(
        _.behaviorCriteriaType
      )
      .optionallyWith(
        listSuppressedAlerts.map(value =>
          ListSuppressedAlerts.unwrap(value): java.lang.Boolean
        )
      )(_.listSuppressedAlerts)
      .optionallyWith(verificationState.map(value => value.unwrap))(
        _.verificationState
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListActiveViolationsRequest.ReadOnly =
    zio.aws.iot.model.ListActiveViolationsRequest.wrap(buildAwsValue())
}
object ListActiveViolationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListActiveViolationsRequest =
      zio.aws.iot.model.ListActiveViolationsRequest(
        thingName.map(value => value),
        securityProfileName.map(value => value),
        behaviorCriteriaType.map(value => value),
        listSuppressedAlerts.map(value => value),
        verificationState.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def thingName: Optional[DeviceDefenderThingName]
    def securityProfileName: Optional[SecurityProfileName]
    def behaviorCriteriaType: Optional[zio.aws.iot.model.BehaviorCriteriaType]
    def listSuppressedAlerts: Optional[ListSuppressedAlerts]
    def verificationState: Optional[zio.aws.iot.model.VerificationState]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getThingName: ZIO[Any, AwsError, DeviceDefenderThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getBehaviorCriteriaType
        : ZIO[Any, AwsError, zio.aws.iot.model.BehaviorCriteriaType] =
      AwsError.unwrapOptionField("behaviorCriteriaType", behaviorCriteriaType)
    def getListSuppressedAlerts: ZIO[Any, AwsError, ListSuppressedAlerts] =
      AwsError.unwrapOptionField("listSuppressedAlerts", listSuppressedAlerts)
    def getVerificationState
        : ZIO[Any, AwsError, zio.aws.iot.model.VerificationState] =
      AwsError.unwrapOptionField("verificationState", verificationState)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest
  ) extends zio.aws.iot.model.ListActiveViolationsRequest.ReadOnly {
    override val thingName: Optional[DeviceDefenderThingName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingName())
        .map(value =>
          zio.aws.iot.model.primitives.DeviceDefenderThingName(value)
        )
    override val securityProfileName: Optional[SecurityProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileName())
        .map(value => zio.aws.iot.model.primitives.SecurityProfileName(value))
    override val behaviorCriteriaType
        : Optional[zio.aws.iot.model.BehaviorCriteriaType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.behaviorCriteriaType())
        .map(value => zio.aws.iot.model.BehaviorCriteriaType.wrap(value))
    override val listSuppressedAlerts: Optional[ListSuppressedAlerts] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listSuppressedAlerts())
        .map(value => zio.aws.iot.model.primitives.ListSuppressedAlerts(value))
    override val verificationState
        : Optional[zio.aws.iot.model.VerificationState] = zio.aws.core.internal
      .optionalFromNullable(impl.verificationState())
      .map(value => zio.aws.iot.model.VerificationState.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest
  ): zio.aws.iot.model.ListActiveViolationsRequest.ReadOnly = new Wrapper(impl)
}
