package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListActiveViolationsResponse(
    activeViolations: Optional[Iterable[zio.aws.iot.model.ActiveViolation]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse = {
    import ListActiveViolationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse
      .builder()
      .optionallyWith(
        activeViolations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeViolations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListActiveViolationsResponse.ReadOnly =
    zio.aws.iot.model.ListActiveViolationsResponse.wrap(buildAwsValue())
}
object ListActiveViolationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListActiveViolationsResponse =
      zio.aws.iot.model.ListActiveViolationsResponse(
        activeViolations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def activeViolations
        : Optional[List[zio.aws.iot.model.ActiveViolation.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getActiveViolations
        : ZIO[Any, AwsError, List[zio.aws.iot.model.ActiveViolation.ReadOnly]] =
      AwsError.unwrapOptionField("activeViolations", activeViolations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse
  ) extends zio.aws.iot.model.ListActiveViolationsResponse.ReadOnly {
    override val activeViolations
        : Optional[List[zio.aws.iot.model.ActiveViolation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeViolations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.ActiveViolation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse
  ): zio.aws.iot.model.ListActiveViolationsResponse.ReadOnly = new Wrapper(impl)
}
