package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  MaxResults,
  NextToken,
  AscendingOrder,
  AuditCheckName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAuditSuppressionsRequest(
    checkName: Optional[AuditCheckName] = Optional.Absent,
    resourceIdentifier: Optional[zio.aws.iot.model.ResourceIdentifier] =
      Optional.Absent,
    ascendingOrder: Optional[AscendingOrder] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest = {
    import ListAuditSuppressionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest
      .builder()
      .optionallyWith(
        checkName.map(value => AuditCheckName.unwrap(value): java.lang.String)
      )(_.checkName)
      .optionallyWith(resourceIdentifier.map(value => value.buildAwsValue()))(
        _.resourceIdentifier
      )
      .optionallyWith(
        ascendingOrder.map(value =>
          AscendingOrder.unwrap(value): java.lang.Boolean
        )
      )(_.ascendingOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListAuditSuppressionsRequest.ReadOnly =
    zio.aws.iot.model.ListAuditSuppressionsRequest.wrap(buildAwsValue())
}
object ListAuditSuppressionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAuditSuppressionsRequest =
      zio.aws.iot.model.ListAuditSuppressionsRequest(
        checkName.map(value => value),
        resourceIdentifier.map(value => value.asEditable),
        ascendingOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def checkName: Optional[AuditCheckName]
    def resourceIdentifier
        : Optional[zio.aws.iot.model.ResourceIdentifier.ReadOnly]
    def ascendingOrder: Optional[AscendingOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getCheckName: ZIO[Any, AwsError, AuditCheckName] =
      AwsError.unwrapOptionField("checkName", checkName)
    def getResourceIdentifier
        : ZIO[Any, AwsError, zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getAscendingOrder: ZIO[Any, AwsError, AscendingOrder] =
      AwsError.unwrapOptionField("ascendingOrder", ascendingOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest
  ) extends zio.aws.iot.model.ListAuditSuppressionsRequest.ReadOnly {
    override val checkName: Optional[AuditCheckName] = zio.aws.core.internal
      .optionalFromNullable(impl.checkName())
      .map(value => zio.aws.iot.model.primitives.AuditCheckName(value))
    override val resourceIdentifier
        : Optional[zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIdentifier())
        .map(value => zio.aws.iot.model.ResourceIdentifier.wrap(value))
    override val ascendingOrder: Optional[AscendingOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ascendingOrder())
        .map(value => zio.aws.iot.model.primitives.AscendingOrder(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest
  ): zio.aws.iot.model.ListAuditSuppressionsRequest.ReadOnly = new Wrapper(impl)
}
