package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAuditSuppressionsResponse(
    suppressions: Optional[Iterable[zio.aws.iot.model.AuditSuppression]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse = {
    import ListAuditSuppressionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse
      .builder()
      .optionallyWith(
        suppressions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suppressions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListAuditSuppressionsResponse.ReadOnly =
    zio.aws.iot.model.ListAuditSuppressionsResponse.wrap(buildAwsValue())
}
object ListAuditSuppressionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAuditSuppressionsResponse =
      zio.aws.iot.model.ListAuditSuppressionsResponse(
        suppressions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def suppressions
        : Optional[List[zio.aws.iot.model.AuditSuppression.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSuppressions: ZIO[Any, AwsError, List[
      zio.aws.iot.model.AuditSuppression.ReadOnly
    ]] = AwsError.unwrapOptionField("suppressions", suppressions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse
  ) extends zio.aws.iot.model.ListAuditSuppressionsResponse.ReadOnly {
    override val suppressions
        : Optional[List[zio.aws.iot.model.AuditSuppression.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.AuditSuppression.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse
  ): zio.aws.iot.model.ListAuditSuppressionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
