package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{MaxResults, NextToken, Timestamp}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAuditTasksRequest(
    startTime: Timestamp,
    endTime: Timestamp,
    taskType: Optional[zio.aws.iot.model.AuditTaskType] = Optional.Absent,
    taskStatus: Optional[zio.aws.iot.model.AuditTaskStatus] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditTasksRequest = {
    import ListAuditTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditTasksRequest
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(taskType.map(value => value.unwrap))(_.taskType)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListAuditTasksRequest.ReadOnly =
    zio.aws.iot.model.ListAuditTasksRequest.wrap(buildAwsValue())
}
object ListAuditTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAuditTasksRequest =
      zio.aws.iot.model.ListAuditTasksRequest(
        startTime,
        endTime,
        taskType.map(value => value),
        taskStatus.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def startTime: Timestamp
    def endTime: Timestamp
    def taskType: Optional[zio.aws.iot.model.AuditTaskType]
    def taskStatus: Optional[zio.aws.iot.model.AuditTaskStatus]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getTaskType: ZIO[Any, AwsError, zio.aws.iot.model.AuditTaskType] =
      AwsError.unwrapOptionField("taskType", taskType)
    def getTaskStatus: ZIO[Any, AwsError, zio.aws.iot.model.AuditTaskStatus] =
      AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditTasksRequest
  ) extends zio.aws.iot.model.ListAuditTasksRequest.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.endTime())
    override val taskType: Optional[zio.aws.iot.model.AuditTaskType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskType())
        .map(value => zio.aws.iot.model.AuditTaskType.wrap(value))
    override val taskStatus: Optional[zio.aws.iot.model.AuditTaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatus())
        .map(value => zio.aws.iot.model.AuditTaskStatus.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditTasksRequest
  ): zio.aws.iot.model.ListAuditTasksRequest.ReadOnly = new Wrapper(impl)
}
