package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Marker
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAuthorizersResponse(
    authorizers: Optional[Iterable[zio.aws.iot.model.AuthorizerSummary]] =
      Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuthorizersResponse = {
    import ListAuthorizersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuthorizersResponse
      .builder()
      .optionallyWith(
        authorizers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.authorizers)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListAuthorizersResponse.ReadOnly =
    zio.aws.iot.model.ListAuthorizersResponse.wrap(buildAwsValue())
}
object ListAuthorizersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuthorizersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAuthorizersResponse =
      zio.aws.iot.model.ListAuthorizersResponse(
        authorizers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def authorizers
        : Optional[List[zio.aws.iot.model.AuthorizerSummary.ReadOnly]]
    def nextMarker: Optional[Marker]
    def getAuthorizers: ZIO[Any, AwsError, List[
      zio.aws.iot.model.AuthorizerSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("authorizers", authorizers)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuthorizersResponse
  ) extends zio.aws.iot.model.ListAuthorizersResponse.ReadOnly {
    override val authorizers
        : Optional[List[zio.aws.iot.model.AuthorizerSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.AuthorizerSummary.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuthorizersResponse
  ): zio.aws.iot.model.ListAuthorizersResponse.ReadOnly = new Wrapper(impl)
}
