package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  BillingGroupName,
  RegistryMaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBillingGroupsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[RegistryMaxResults] = Optional.Absent,
    namePrefixFilter: Optional[BillingGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest = {
    import ListBillingGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        namePrefixFilter.map(value =>
          BillingGroupName.unwrap(value): java.lang.String
        )
      )(_.namePrefixFilter)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListBillingGroupsRequest.ReadOnly =
    zio.aws.iot.model.ListBillingGroupsRequest.wrap(buildAwsValue())
}
object ListBillingGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListBillingGroupsRequest =
      zio.aws.iot.model.ListBillingGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        namePrefixFilter.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[RegistryMaxResults]
    def namePrefixFilter: Optional[BillingGroupName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamePrefixFilter: ZIO[Any, AwsError, BillingGroupName] =
      AwsError.unwrapOptionField("namePrefixFilter", namePrefixFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest
  ) extends zio.aws.iot.model.ListBillingGroupsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[RegistryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val namePrefixFilter: Optional[BillingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namePrefixFilter())
        .map(value => zio.aws.iot.model.primitives.BillingGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest
  ): zio.aws.iot.model.ListBillingGroupsRequest.ReadOnly = new Wrapper(impl)
}
