package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  AscendingOrder,
  Marker,
  PageSize,
  CertificateId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCertificatesByCaRequest(
    caCertificateId: CertificateId,
    pageSize: Optional[PageSize] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    ascendingOrder: Optional[AscendingOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest = {
    import ListCertificatesByCaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest
      .builder()
      .caCertificateId(CertificateId.unwrap(caCertificateId): java.lang.String)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        ascendingOrder.map(value =>
          AscendingOrder.unwrap(value): java.lang.Boolean
        )
      )(_.ascendingOrder)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListCertificatesByCaRequest.ReadOnly =
    zio.aws.iot.model.ListCertificatesByCaRequest.wrap(buildAwsValue())
}
object ListCertificatesByCaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListCertificatesByCaRequest =
      zio.aws.iot.model.ListCertificatesByCaRequest(
        caCertificateId,
        pageSize.map(value => value),
        marker.map(value => value),
        ascendingOrder.map(value => value)
      )
    def caCertificateId: CertificateId
    def pageSize: Optional[PageSize]
    def marker: Optional[Marker]
    def ascendingOrder: Optional[AscendingOrder]
    def getCaCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(caCertificateId)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getAscendingOrder: ZIO[Any, AwsError, AscendingOrder] =
      AwsError.unwrapOptionField("ascendingOrder", ascendingOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest
  ) extends zio.aws.iot.model.ListCertificatesByCaRequest.ReadOnly {
    override val caCertificateId: CertificateId =
      zio.aws.iot.model.primitives.CertificateId(impl.caCertificateId())
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.iot.model.primitives.PageSize(value))
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
    override val ascendingOrder: Optional[AscendingOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ascendingOrder())
        .map(value => zio.aws.iot.model.primitives.AscendingOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest
  ): zio.aws.iot.model.ListCertificatesByCaRequest.ReadOnly = new Wrapper(impl)
}
