package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{Timestamp, NextToken, MaxResults}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDetectMitigationActionsTasksRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    startTime: Timestamp,
    endTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest = {
    import ListDetectMitigationActionsTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListDetectMitigationActionsTasksRequest.ReadOnly =
    zio.aws.iot.model.ListDetectMitigationActionsTasksRequest
      .wrap(buildAwsValue())
}
object ListDetectMitigationActionsTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListDetectMitigationActionsTasksRequest =
      zio.aws.iot.model.ListDetectMitigationActionsTasksRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        startTime,
        endTime
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def startTime: Timestamp
    def endTime: Timestamp
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest
  ) extends zio.aws.iot.model.ListDetectMitigationActionsTasksRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val startTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest
  ): zio.aws.iot.model.ListDetectMitigationActionsTasksRequest.ReadOnly =
    new Wrapper(impl)
}
