package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{PageSize, Marker}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDomainConfigurationsRequest(
    marker: Optional[Marker] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent,
    serviceType: Optional[zio.aws.iot.model.ServiceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest = {
    import ListDomainConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(serviceType.map(value => value.unwrap))(_.serviceType)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListDomainConfigurationsRequest.ReadOnly =
    zio.aws.iot.model.ListDomainConfigurationsRequest.wrap(buildAwsValue())
}
object ListDomainConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListDomainConfigurationsRequest =
      zio.aws.iot.model.ListDomainConfigurationsRequest(
        marker.map(value => value),
        pageSize.map(value => value),
        serviceType.map(value => value)
      )
    def marker: Optional[Marker]
    def pageSize: Optional[PageSize]
    def serviceType: Optional[zio.aws.iot.model.ServiceType]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getServiceType: ZIO[Any, AwsError, zio.aws.iot.model.ServiceType] =
      AwsError.unwrapOptionField("serviceType", serviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest
  ) extends zio.aws.iot.model.ListDomainConfigurationsRequest.ReadOnly {
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.iot.model.primitives.PageSize(value))
    override val serviceType: Optional[zio.aws.iot.model.ServiceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceType())
        .map(value => zio.aws.iot.model.ServiceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest
  ): zio.aws.iot.model.ListDomainConfigurationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
