package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{NextToken, LaserMaxResults, JobId}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListJobExecutionsForJobRequest(
    jobId: JobId,
    status: Optional[zio.aws.iot.model.JobExecutionStatus] = Optional.Absent,
    maxResults: Optional[LaserMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest = {
    import ListJobExecutionsForJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        maxResults.map(value => LaserMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListJobExecutionsForJobRequest.ReadOnly =
    zio.aws.iot.model.ListJobExecutionsForJobRequest.wrap(buildAwsValue())
}
object ListJobExecutionsForJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListJobExecutionsForJobRequest =
      zio.aws.iot.model.ListJobExecutionsForJobRequest(
        jobId,
        status.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def jobId: JobId
    def status: Optional[zio.aws.iot.model.JobExecutionStatus]
    def maxResults: Optional[LaserMaxResults]
    def nextToken: Optional[NextToken]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMaxResults: ZIO[Any, AwsError, LaserMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest
  ) extends zio.aws.iot.model.ListJobExecutionsForJobRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val status: Optional[zio.aws.iot.model.JobExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.JobExecutionStatus.wrap(value))
    override val maxResults: Optional[LaserMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.LaserMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest
  ): zio.aws.iot.model.ListJobExecutionsForJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
