package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  NextToken,
  NamespaceId,
  ThingName,
  JobId,
  LaserMaxResults
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListJobExecutionsForThingRequest(
    thingName: ThingName,
    status: Optional[zio.aws.iot.model.JobExecutionStatus] = Optional.Absent,
    namespaceId: Optional[NamespaceId] = Optional.Absent,
    maxResults: Optional[LaserMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest = {
    import ListJobExecutionsForThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .optionallyWith(
        maxResults.map(value => LaserMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListJobExecutionsForThingRequest.ReadOnly =
    zio.aws.iot.model.ListJobExecutionsForThingRequest.wrap(buildAwsValue())
}
object ListJobExecutionsForThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListJobExecutionsForThingRequest =
      zio.aws.iot.model.ListJobExecutionsForThingRequest(
        thingName,
        status.map(value => value),
        namespaceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        jobId.map(value => value)
      )
    def thingName: ThingName
    def status: Optional[zio.aws.iot.model.JobExecutionStatus]
    def namespaceId: Optional[NamespaceId]
    def maxResults: Optional[LaserMaxResults]
    def nextToken: Optional[NextToken]
    def jobId: Optional[JobId]
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
    def getMaxResults: ZIO[Any, AwsError, LaserMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest
  ) extends zio.aws.iot.model.ListJobExecutionsForThingRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val status: Optional[zio.aws.iot.model.JobExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.JobExecutionStatus.wrap(value))
    override val namespaceId: Optional[NamespaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
    override val maxResults: Optional[LaserMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.LaserMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.iot.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest
  ): zio.aws.iot.model.ListJobExecutionsForThingRequest.ReadOnly = new Wrapper(
    impl
  )
}
