package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  NextToken,
  LaserMaxResults,
  ManagedJobTemplateName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListManagedJobTemplatesRequest(
    templateName: Optional[ManagedJobTemplateName] = Optional.Absent,
    maxResults: Optional[LaserMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest = {
    import ListManagedJobTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest
      .builder()
      .optionallyWith(
        templateName.map(value =>
          ManagedJobTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        maxResults.map(value => LaserMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListManagedJobTemplatesRequest.ReadOnly =
    zio.aws.iot.model.ListManagedJobTemplatesRequest.wrap(buildAwsValue())
}
object ListManagedJobTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListManagedJobTemplatesRequest =
      zio.aws.iot.model.ListManagedJobTemplatesRequest(
        templateName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def templateName: Optional[ManagedJobTemplateName]
    def maxResults: Optional[LaserMaxResults]
    def nextToken: Optional[NextToken]
    def getTemplateName: ZIO[Any, AwsError, ManagedJobTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getMaxResults: ZIO[Any, AwsError, LaserMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest
  ) extends zio.aws.iot.model.ListManagedJobTemplatesRequest.ReadOnly {
    override val templateName: Optional[ManagedJobTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value =>
          zio.aws.iot.model.primitives.ManagedJobTemplateName(value)
        )
    override val maxResults: Optional[LaserMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.LaserMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest
  ): zio.aws.iot.model.ListManagedJobTemplatesRequest.ReadOnly = new Wrapper(
    impl
  )
}
