package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DeviceDefenderThingName,
  NextToken,
  Timestamp,
  MaxResults,
  BehaviorMetric,
  DimensionName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMetricValuesRequest(
    thingName: DeviceDefenderThingName,
    metricName: BehaviorMetric,
    dimensionName: Optional[DimensionName] = Optional.Absent,
    dimensionValueOperator: Optional[zio.aws.iot.model.DimensionValueOperator] =
      Optional.Absent,
    startTime: Timestamp,
    endTime: Timestamp,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListMetricValuesRequest = {
    import ListMetricValuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListMetricValuesRequest
      .builder()
      .thingName(DeviceDefenderThingName.unwrap(thingName): java.lang.String)
      .metricName(BehaviorMetric.unwrap(metricName): java.lang.String)
      .optionallyWith(
        dimensionName.map(value =>
          DimensionName.unwrap(value): java.lang.String
        )
      )(_.dimensionName)
      .optionallyWith(dimensionValueOperator.map(value => value.unwrap))(
        _.dimensionValueOperator
      )
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListMetricValuesRequest.ReadOnly =
    zio.aws.iot.model.ListMetricValuesRequest.wrap(buildAwsValue())
}
object ListMetricValuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListMetricValuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListMetricValuesRequest =
      zio.aws.iot.model.ListMetricValuesRequest(
        thingName,
        metricName,
        dimensionName.map(value => value),
        dimensionValueOperator.map(value => value),
        startTime,
        endTime,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def thingName: DeviceDefenderThingName
    def metricName: BehaviorMetric
    def dimensionName: Optional[DimensionName]
    def dimensionValueOperator
        : Optional[zio.aws.iot.model.DimensionValueOperator]
    def startTime: Timestamp
    def endTime: Timestamp
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getThingName: ZIO[Any, Nothing, DeviceDefenderThingName] =
      ZIO.succeed(thingName)
    def getMetricName: ZIO[Any, Nothing, BehaviorMetric] =
      ZIO.succeed(metricName)
    def getDimensionName: ZIO[Any, AwsError, DimensionName] =
      AwsError.unwrapOptionField("dimensionName", dimensionName)
    def getDimensionValueOperator
        : ZIO[Any, AwsError, zio.aws.iot.model.DimensionValueOperator] =
      AwsError.unwrapOptionField(
        "dimensionValueOperator",
        dimensionValueOperator
      )
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListMetricValuesRequest
  ) extends zio.aws.iot.model.ListMetricValuesRequest.ReadOnly {
    override val thingName: DeviceDefenderThingName =
      zio.aws.iot.model.primitives.DeviceDefenderThingName(impl.thingName())
    override val metricName: BehaviorMetric =
      zio.aws.iot.model.primitives.BehaviorMetric(impl.metricName())
    override val dimensionName: Optional[DimensionName] = zio.aws.core.internal
      .optionalFromNullable(impl.dimensionName())
      .map(value => zio.aws.iot.model.primitives.DimensionName(value))
    override val dimensionValueOperator
        : Optional[zio.aws.iot.model.DimensionValueOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensionValueOperator())
        .map(value => zio.aws.iot.model.DimensionValueOperator.wrap(value))
    override val startTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.endTime())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListMetricValuesRequest
  ): zio.aws.iot.model.ListMetricValuesRequest.ReadOnly = new Wrapper(impl)
}
