package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMetricValuesResponse(
    metricDatumList: Optional[Iterable[zio.aws.iot.model.MetricDatum]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListMetricValuesResponse = {
    import ListMetricValuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListMetricValuesResponse
      .builder()
      .optionallyWith(
        metricDatumList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDatumList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListMetricValuesResponse.ReadOnly =
    zio.aws.iot.model.ListMetricValuesResponse.wrap(buildAwsValue())
}
object ListMetricValuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListMetricValuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListMetricValuesResponse =
      zio.aws.iot.model.ListMetricValuesResponse(
        metricDatumList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def metricDatumList: Optional[List[zio.aws.iot.model.MetricDatum.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getMetricDatumList
        : ZIO[Any, AwsError, List[zio.aws.iot.model.MetricDatum.ReadOnly]] =
      AwsError.unwrapOptionField("metricDatumList", metricDatumList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListMetricValuesResponse
  ) extends zio.aws.iot.model.ListMetricValuesResponse.ReadOnly {
    override val metricDatumList
        : Optional[List[zio.aws.iot.model.MetricDatum.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDatumList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.MetricDatum.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListMetricValuesResponse
  ): zio.aws.iot.model.ListMetricValuesResponse.ReadOnly = new Wrapper(impl)
}
