package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{NextToken, MaxResults}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListOtaUpdatesRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    otaUpdateStatus: Optional[zio.aws.iot.model.OTAUpdateStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest = {
    import ListOtaUpdatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(otaUpdateStatus.map(value => value.unwrap))(
        _.otaUpdateStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListOtaUpdatesRequest.ReadOnly =
    zio.aws.iot.model.ListOtaUpdatesRequest.wrap(buildAwsValue())
}
object ListOtaUpdatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListOtaUpdatesRequest =
      zio.aws.iot.model.ListOtaUpdatesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        otaUpdateStatus.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def otaUpdateStatus: Optional[zio.aws.iot.model.OTAUpdateStatus]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOtaUpdateStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.OTAUpdateStatus] =
      AwsError.unwrapOptionField("otaUpdateStatus", otaUpdateStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest
  ) extends zio.aws.iot.model.ListOtaUpdatesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val otaUpdateStatus: Optional[zio.aws.iot.model.OTAUpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.otaUpdateStatus())
        .map(value => zio.aws.iot.model.OTAUpdateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest
  ): zio.aws.iot.model.ListOtaUpdatesRequest.ReadOnly = new Wrapper(impl)
}
