package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOtaUpdatesResponse(
    otaUpdates: Optional[Iterable[zio.aws.iot.model.OTAUpdateSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse = {
    import ListOtaUpdatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse
      .builder()
      .optionallyWith(
        otaUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.otaUpdates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListOtaUpdatesResponse.ReadOnly =
    zio.aws.iot.model.ListOtaUpdatesResponse.wrap(buildAwsValue())
}
object ListOtaUpdatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListOtaUpdatesResponse =
      zio.aws.iot.model.ListOtaUpdatesResponse(
        otaUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def otaUpdates: Optional[List[zio.aws.iot.model.OTAUpdateSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getOtaUpdates: ZIO[Any, AwsError, List[
      zio.aws.iot.model.OTAUpdateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("otaUpdates", otaUpdates)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse
  ) extends zio.aws.iot.model.ListOtaUpdatesResponse.ReadOnly {
    override val otaUpdates
        : Optional[List[zio.aws.iot.model.OTAUpdateSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.otaUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.OTAUpdateSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse
  ): zio.aws.iot.model.ListOtaUpdatesResponse.ReadOnly = new Wrapper(impl)
}
