package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Marker
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOutgoingCertificatesResponse(
    outgoingCertificates: Optional[
      Iterable[zio.aws.iot.model.OutgoingCertificate]
    ] = Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse = {
    import ListOutgoingCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse
      .builder()
      .optionallyWith(
        outgoingCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outgoingCertificates)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListOutgoingCertificatesResponse.ReadOnly =
    zio.aws.iot.model.ListOutgoingCertificatesResponse.wrap(buildAwsValue())
}
object ListOutgoingCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListOutgoingCertificatesResponse =
      zio.aws.iot.model.ListOutgoingCertificatesResponse(
        outgoingCertificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def outgoingCertificates
        : Optional[List[zio.aws.iot.model.OutgoingCertificate.ReadOnly]]
    def nextMarker: Optional[Marker]
    def getOutgoingCertificates: ZIO[Any, AwsError, List[
      zio.aws.iot.model.OutgoingCertificate.ReadOnly
    ]] =
      AwsError.unwrapOptionField("outgoingCertificates", outgoingCertificates)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse
  ) extends zio.aws.iot.model.ListOutgoingCertificatesResponse.ReadOnly {
    override val outgoingCertificates
        : Optional[List[zio.aws.iot.model.OutgoingCertificate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outgoingCertificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.OutgoingCertificate.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse
  ): zio.aws.iot.model.ListOutgoingCertificatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
