package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{AscendingOrder, PageSize, Marker}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPoliciesRequest(
    marker: Optional[Marker] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent,
    ascendingOrder: Optional[AscendingOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListPoliciesRequest = {
    import ListPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListPoliciesRequest
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        ascendingOrder.map(value =>
          AscendingOrder.unwrap(value): java.lang.Boolean
        )
      )(_.ascendingOrder)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListPoliciesRequest.ReadOnly =
    zio.aws.iot.model.ListPoliciesRequest.wrap(buildAwsValue())
}
object ListPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListPoliciesRequest =
      zio.aws.iot.model.ListPoliciesRequest(
        marker.map(value => value),
        pageSize.map(value => value),
        ascendingOrder.map(value => value)
      )
    def marker: Optional[Marker]
    def pageSize: Optional[PageSize]
    def ascendingOrder: Optional[AscendingOrder]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getAscendingOrder: ZIO[Any, AwsError, AscendingOrder] =
      AwsError.unwrapOptionField("ascendingOrder", ascendingOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListPoliciesRequest
  ) extends zio.aws.iot.model.ListPoliciesRequest.ReadOnly {
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.iot.model.primitives.PageSize(value))
    override val ascendingOrder: Optional[AscendingOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ascendingOrder())
        .map(value => zio.aws.iot.model.primitives.AscendingOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListPoliciesRequest
  ): zio.aws.iot.model.ListPoliciesRequest.ReadOnly = new Wrapper(impl)
}
