package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.PolicyName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListPolicyVersionsRequest(policyName: PolicyName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest = {
    import ListPolicyVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListPolicyVersionsRequest.ReadOnly =
    zio.aws.iot.model.ListPolicyVersionsRequest.wrap(buildAwsValue())
}
object ListPolicyVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListPolicyVersionsRequest =
      zio.aws.iot.model.ListPolicyVersionsRequest(policyName)
    def policyName: PolicyName
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest
  ) extends zio.aws.iot.model.ListPolicyVersionsRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.iot.model.primitives.PolicyName(impl.policyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest
  ): zio.aws.iot.model.ListPolicyVersionsRequest.ReadOnly = new Wrapper(impl)
}
