package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, ThingName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPrincipalThingsResponse(
    things: Optional[Iterable[ThingName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse = {
    import ListPrincipalThingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse
      .builder()
      .optionallyWith(
        things.map(value =>
          value.map { item =>
            ThingName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.things)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListPrincipalThingsResponse.ReadOnly =
    zio.aws.iot.model.ListPrincipalThingsResponse.wrap(buildAwsValue())
}
object ListPrincipalThingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListPrincipalThingsResponse =
      zio.aws.iot.model.ListPrincipalThingsResponse(
        things.map(value => value),
        nextToken.map(value => value)
      )
    def things: Optional[List[ThingName]]
    def nextToken: Optional[NextToken]
    def getThings: ZIO[Any, AwsError, List[ThingName]] =
      AwsError.unwrapOptionField("things", things)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse
  ) extends zio.aws.iot.model.ListPrincipalThingsResponse.ReadOnly {
    override val things: Optional[List[ThingName]] = zio.aws.core.internal
      .optionalFromNullable(impl.things())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.ThingName(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse
  ): zio.aws.iot.model.ListPrincipalThingsResponse.ReadOnly = new Wrapper(impl)
}
