package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Marker, RoleAlias}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRoleAliasesResponse(
    roleAliases: Optional[Iterable[RoleAlias]] = Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse = {
    import ListRoleAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse
      .builder()
      .optionallyWith(
        roleAliases.map(value =>
          value.map { item =>
            RoleAlias.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.roleAliases)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListRoleAliasesResponse.ReadOnly =
    zio.aws.iot.model.ListRoleAliasesResponse.wrap(buildAwsValue())
}
object ListRoleAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListRoleAliasesResponse =
      zio.aws.iot.model.ListRoleAliasesResponse(
        roleAliases.map(value => value),
        nextMarker.map(value => value)
      )
    def roleAliases: Optional[List[RoleAlias]]
    def nextMarker: Optional[Marker]
    def getRoleAliases: ZIO[Any, AwsError, List[RoleAlias]] =
      AwsError.unwrapOptionField("roleAliases", roleAliases)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse
  ) extends zio.aws.iot.model.ListRoleAliasesResponse.ReadOnly {
    override val roleAliases: Optional[List[RoleAlias]] = zio.aws.core.internal
      .optionalFromNullable(impl.roleAliases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.RoleAlias(item)
        }.toList
      )
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse
  ): zio.aws.iot.model.ListRoleAliasesResponse.ReadOnly = new Wrapper(impl)
}
