package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListScheduledAuditsResponse(
    scheduledAudits: Optional[
      Iterable[zio.aws.iot.model.ScheduledAuditMetadata]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse = {
    import ListScheduledAuditsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse
      .builder()
      .optionallyWith(
        scheduledAudits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduledAudits)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListScheduledAuditsResponse.ReadOnly =
    zio.aws.iot.model.ListScheduledAuditsResponse.wrap(buildAwsValue())
}
object ListScheduledAuditsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListScheduledAuditsResponse =
      zio.aws.iot.model.ListScheduledAuditsResponse(
        scheduledAudits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scheduledAudits
        : Optional[List[zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getScheduledAudits: ZIO[Any, AwsError, List[
      zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("scheduledAudits", scheduledAudits)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse
  ) extends zio.aws.iot.model.ListScheduledAuditsResponse.ReadOnly {
    override val scheduledAudits
        : Optional[List[zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledAudits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.ScheduledAuditMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse
  ): zio.aws.iot.model.ListScheduledAuditsResponse.ReadOnly = new Wrapper(impl)
}
