package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSecurityProfilesForTargetResponse(
    securityProfileTargetMappings: Optional[
      Iterable[zio.aws.iot.model.SecurityProfileTargetMapping]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse = {
    import ListSecurityProfilesForTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse
      .builder()
      .optionallyWith(
        securityProfileTargetMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityProfileTargetMappings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListSecurityProfilesForTargetResponse.ReadOnly =
    zio.aws.iot.model.ListSecurityProfilesForTargetResponse
      .wrap(buildAwsValue())
}
object ListSecurityProfilesForTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListSecurityProfilesForTargetResponse =
      zio.aws.iot.model.ListSecurityProfilesForTargetResponse(
        securityProfileTargetMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def securityProfileTargetMappings: Optional[
      List[zio.aws.iot.model.SecurityProfileTargetMapping.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSecurityProfileTargetMappings: ZIO[Any, AwsError, List[
      zio.aws.iot.model.SecurityProfileTargetMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "securityProfileTargetMappings",
      securityProfileTargetMappings
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse
  ) extends zio.aws.iot.model.ListSecurityProfilesForTargetResponse.ReadOnly {
    override val securityProfileTargetMappings: Optional[
      List[zio.aws.iot.model.SecurityProfileTargetMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityProfileTargetMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.SecurityProfileTargetMapping.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse
  ): zio.aws.iot.model.ListSecurityProfilesForTargetResponse.ReadOnly =
    new Wrapper(impl)
}
