package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  MetricName,
  DimensionName,
  MaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSecurityProfilesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    dimensionName: Optional[DimensionName] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest = {
    import ListSecurityProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        dimensionName.map(value =>
          DimensionName.unwrap(value): java.lang.String
        )
      )(_.dimensionName)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListSecurityProfilesRequest.ReadOnly =
    zio.aws.iot.model.ListSecurityProfilesRequest.wrap(buildAwsValue())
}
object ListSecurityProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListSecurityProfilesRequest =
      zio.aws.iot.model.ListSecurityProfilesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        dimensionName.map(value => value),
        metricName.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def dimensionName: Optional[DimensionName]
    def metricName: Optional[MetricName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDimensionName: ZIO[Any, AwsError, DimensionName] =
      AwsError.unwrapOptionField("dimensionName", dimensionName)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest
  ) extends zio.aws.iot.model.ListSecurityProfilesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val dimensionName: Optional[DimensionName] = zio.aws.core.internal
      .optionalFromNullable(impl.dimensionName())
      .map(value => zio.aws.iot.model.primitives.DimensionName(value))
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.iot.model.primitives.MetricName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest
  ): zio.aws.iot.model.ListSecurityProfilesRequest.ReadOnly = new Wrapper(impl)
}
