package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSecurityProfilesResponse(
    securityProfileIdentifiers: Optional[
      Iterable[zio.aws.iot.model.SecurityProfileIdentifier]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListSecurityProfilesResponse = {
    import ListSecurityProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListSecurityProfilesResponse
      .builder()
      .optionallyWith(
        securityProfileIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityProfileIdentifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListSecurityProfilesResponse.ReadOnly =
    zio.aws.iot.model.ListSecurityProfilesResponse.wrap(buildAwsValue())
}
object ListSecurityProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListSecurityProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListSecurityProfilesResponse =
      zio.aws.iot.model.ListSecurityProfilesResponse(
        securityProfileIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def securityProfileIdentifiers
        : Optional[List[zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSecurityProfileIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "securityProfileIdentifiers",
      securityProfileIdentifiers
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListSecurityProfilesResponse
  ) extends zio.aws.iot.model.ListSecurityProfilesResponse.ReadOnly {
    override val securityProfileIdentifiers
        : Optional[List[zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.SecurityProfileIdentifier.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListSecurityProfilesResponse
  ): zio.aws.iot.model.ListSecurityProfilesResponse.ReadOnly = new Wrapper(impl)
}
