package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{AscendingOrder, NextToken, MaxResults}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStreamsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    ascendingOrder: Optional[AscendingOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListStreamsRequest = {
    import ListStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListStreamsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ascendingOrder.map(value =>
          AscendingOrder.unwrap(value): java.lang.Boolean
        )
      )(_.ascendingOrder)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListStreamsRequest.ReadOnly =
    zio.aws.iot.model.ListStreamsRequest.wrap(buildAwsValue())
}
object ListStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListStreamsRequest =
      zio.aws.iot.model.ListStreamsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        ascendingOrder.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def ascendingOrder: Optional[AscendingOrder]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAscendingOrder: ZIO[Any, AwsError, AscendingOrder] =
      AwsError.unwrapOptionField("ascendingOrder", ascendingOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListStreamsRequest
  ) extends zio.aws.iot.model.ListStreamsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val ascendingOrder: Optional[AscendingOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ascendingOrder())
        .map(value => zio.aws.iot.model.primitives.AscendingOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListStreamsRequest
  ): zio.aws.iot.model.ListStreamsRequest.ReadOnly = new Wrapper(impl)
}
