package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{PageSize, Marker, PolicyName}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTargetsForPolicyRequest(
    policyName: PolicyName,
    marker: Optional[Marker] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest = {
    import ListTargetsForPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListTargetsForPolicyRequest.ReadOnly =
    zio.aws.iot.model.ListTargetsForPolicyRequest.wrap(buildAwsValue())
}
object ListTargetsForPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListTargetsForPolicyRequest =
      zio.aws.iot.model.ListTargetsForPolicyRequest(
        policyName,
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def policyName: PolicyName
    def marker: Optional[Marker]
    def pageSize: Optional[PageSize]
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest
  ) extends zio.aws.iot.model.ListTargetsForPolicyRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.iot.model.primitives.PolicyName(impl.policyName())
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.iot.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest
  ): zio.aws.iot.model.ListTargetsForPolicyRequest.ReadOnly = new Wrapper(impl)
}
