package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Marker, PolicyTarget}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTargetsForPolicyResponse(
    targets: Optional[Iterable[PolicyTarget]] = Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse = {
    import ListTargetsForPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse
      .builder()
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            PolicyTarget.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListTargetsForPolicyResponse.ReadOnly =
    zio.aws.iot.model.ListTargetsForPolicyResponse.wrap(buildAwsValue())
}
object ListTargetsForPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListTargetsForPolicyResponse =
      zio.aws.iot.model.ListTargetsForPolicyResponse(
        targets.map(value => value),
        nextMarker.map(value => value)
      )
    def targets: Optional[List[PolicyTarget]]
    def nextMarker: Optional[Marker]
    def getTargets: ZIO[Any, AwsError, List[PolicyTarget]] =
      AwsError.unwrapOptionField("targets", targets)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse
  ) extends zio.aws.iot.model.ListTargetsForPolicyResponse.ReadOnly {
    override val targets: Optional[List[PolicyTarget]] = zio.aws.core.internal
      .optionalFromNullable(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.PolicyTarget(item)
        }.toList
      )
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse
  ): zio.aws.iot.model.ListTargetsForPolicyResponse.ReadOnly = new Wrapper(impl)
}
