package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{MaxResults, NextToken, SecurityProfileName}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTargetsForSecurityProfileRequest(
    securityProfileName: SecurityProfileName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest = {
    import ListTargetsForSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest
      .builder()
      .securityProfileName(
        SecurityProfileName.unwrap(securityProfileName): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListTargetsForSecurityProfileRequest.ReadOnly =
    zio.aws.iot.model.ListTargetsForSecurityProfileRequest.wrap(buildAwsValue())
}
object ListTargetsForSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListTargetsForSecurityProfileRequest =
      zio.aws.iot.model.ListTargetsForSecurityProfileRequest(
        securityProfileName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def securityProfileName: SecurityProfileName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSecurityProfileName: ZIO[Any, Nothing, SecurityProfileName] =
      ZIO.succeed(securityProfileName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest
  ) extends zio.aws.iot.model.ListTargetsForSecurityProfileRequest.ReadOnly {
    override val securityProfileName: SecurityProfileName =
      zio.aws.iot.model.primitives
        .SecurityProfileName(impl.securityProfileName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest
  ): zio.aws.iot.model.ListTargetsForSecurityProfileRequest.ReadOnly =
    new Wrapper(impl)
}
