package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTargetsForSecurityProfileResponse(
    securityProfileTargets: Optional[
      Iterable[zio.aws.iot.model.SecurityProfileTarget]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse = {
    import ListTargetsForSecurityProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse
      .builder()
      .optionallyWith(
        securityProfileTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityProfileTargets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListTargetsForSecurityProfileResponse.ReadOnly =
    zio.aws.iot.model.ListTargetsForSecurityProfileResponse
      .wrap(buildAwsValue())
}
object ListTargetsForSecurityProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListTargetsForSecurityProfileResponse =
      zio.aws.iot.model.ListTargetsForSecurityProfileResponse(
        securityProfileTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def securityProfileTargets
        : Optional[List[zio.aws.iot.model.SecurityProfileTarget.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSecurityProfileTargets: ZIO[Any, AwsError, List[
      zio.aws.iot.model.SecurityProfileTarget.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "securityProfileTargets",
      securityProfileTargets
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse
  ) extends zio.aws.iot.model.ListTargetsForSecurityProfileResponse.ReadOnly {
    override val securityProfileTargets
        : Optional[List[zio.aws.iot.model.SecurityProfileTarget.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.SecurityProfileTarget.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse
  ): zio.aws.iot.model.ListTargetsForSecurityProfileResponse.ReadOnly =
    new Wrapper(impl)
}
