package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, PrincipalArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListThingPrincipalsResponse(
    principals: Optional[Iterable[PrincipalArn]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse = {
    import ListThingPrincipalsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse
      .builder()
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            PrincipalArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingPrincipalsResponse.ReadOnly =
    zio.aws.iot.model.ListThingPrincipalsResponse.wrap(buildAwsValue())
}
object ListThingPrincipalsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingPrincipalsResponse =
      zio.aws.iot.model.ListThingPrincipalsResponse(
        principals.map(value => value),
        nextToken.map(value => value)
      )
    def principals: Optional[List[PrincipalArn]]
    def nextToken: Optional[NextToken]
    def getPrincipals: ZIO[Any, AwsError, List[PrincipalArn]] =
      AwsError.unwrapOptionField("principals", principals)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse
  ) extends zio.aws.iot.model.ListThingPrincipalsResponse.ReadOnly {
    override val principals: Optional[List[PrincipalArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.PrincipalArn(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse
  ): zio.aws.iot.model.ListThingPrincipalsResponse.ReadOnly = new Wrapper(impl)
}
