package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, TaskId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListThingRegistrationTasksResponse(
    taskIds: Optional[Iterable[TaskId]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse = {
    import ListThingRegistrationTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse
      .builder()
      .optionallyWith(
        taskIds.map(value =>
          value.map { item =>
            TaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.taskIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListThingRegistrationTasksResponse.ReadOnly =
    zio.aws.iot.model.ListThingRegistrationTasksResponse.wrap(buildAwsValue())
}
object ListThingRegistrationTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingRegistrationTasksResponse =
      zio.aws.iot.model.ListThingRegistrationTasksResponse(
        taskIds.map(value => value),
        nextToken.map(value => value)
      )
    def taskIds: Optional[List[TaskId]]
    def nextToken: Optional[NextToken]
    def getTaskIds: ZIO[Any, AwsError, List[TaskId]] =
      AwsError.unwrapOptionField("taskIds", taskIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse
  ) extends zio.aws.iot.model.ListThingRegistrationTasksResponse.ReadOnly {
    override val taskIds: Optional[List[TaskId]] = zio.aws.core.internal
      .optionalFromNullable(impl.taskIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.TaskId(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse
  ): zio.aws.iot.model.ListThingRegistrationTasksResponse.ReadOnly =
    new Wrapper(impl)
}
