package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListThingTypesResponse(
    thingTypes: Optional[Iterable[zio.aws.iot.model.ThingTypeDefinition]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingTypesResponse = {
    import ListThingTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingTypesResponse
      .builder()
      .optionallyWith(
        thingTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.thingTypes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingTypesResponse.ReadOnly =
    zio.aws.iot.model.ListThingTypesResponse.wrap(buildAwsValue())
}
object ListThingTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingTypesResponse =
      zio.aws.iot.model.ListThingTypesResponse(
        thingTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def thingTypes
        : Optional[List[zio.aws.iot.model.ThingTypeDefinition.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getThingTypes: ZIO[Any, AwsError, List[
      zio.aws.iot.model.ThingTypeDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("thingTypes", thingTypes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingTypesResponse
  ) extends zio.aws.iot.model.ListThingTypesResponse.ReadOnly {
    override val thingTypes
        : Optional[List[zio.aws.iot.model.ThingTypeDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.ThingTypeDefinition.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingTypesResponse
  ): zio.aws.iot.model.ListThingTypesResponse.ReadOnly = new Wrapper(impl)
}
