package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RegistryMaxResults,
  NextToken,
  BillingGroupName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListThingsInBillingGroupRequest(
    billingGroupName: BillingGroupName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[RegistryMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest = {
    import ListThingsInBillingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest
      .builder()
      .billingGroupName(
        BillingGroupName.unwrap(billingGroupName): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingsInBillingGroupRequest.ReadOnly =
    zio.aws.iot.model.ListThingsInBillingGroupRequest.wrap(buildAwsValue())
}
object ListThingsInBillingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingsInBillingGroupRequest =
      zio.aws.iot.model.ListThingsInBillingGroupRequest(
        billingGroupName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def billingGroupName: BillingGroupName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[RegistryMaxResults]
    def getBillingGroupName: ZIO[Any, Nothing, BillingGroupName] =
      ZIO.succeed(billingGroupName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest
  ) extends zio.aws.iot.model.ListThingsInBillingGroupRequest.ReadOnly {
    override val billingGroupName: BillingGroupName =
      zio.aws.iot.model.primitives.BillingGroupName(impl.billingGroupName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[RegistryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest
  ): zio.aws.iot.model.ListThingsInBillingGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
