package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RegistryMaxResults,
  NextToken,
  Recursive,
  ThingGroupName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListThingsInThingGroupRequest(
    thingGroupName: ThingGroupName,
    recursive: Optional[Recursive] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[RegistryMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest = {
    import ListThingsInThingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest
      .builder()
      .thingGroupName(ThingGroupName.unwrap(thingGroupName): java.lang.String)
      .optionallyWith(
        recursive.map(value => Recursive.unwrap(value): java.lang.Boolean)
      )(_.recursive)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingsInThingGroupRequest.ReadOnly =
    zio.aws.iot.model.ListThingsInThingGroupRequest.wrap(buildAwsValue())
}
object ListThingsInThingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingsInThingGroupRequest =
      zio.aws.iot.model.ListThingsInThingGroupRequest(
        thingGroupName,
        recursive.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def thingGroupName: ThingGroupName
    def recursive: Optional[Recursive]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[RegistryMaxResults]
    def getThingGroupName: ZIO[Any, Nothing, ThingGroupName] =
      ZIO.succeed(thingGroupName)
    def getRecursive: ZIO[Any, AwsError, Recursive] =
      AwsError.unwrapOptionField("recursive", recursive)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest
  ) extends zio.aws.iot.model.ListThingsInThingGroupRequest.ReadOnly {
    override val thingGroupName: ThingGroupName =
      zio.aws.iot.model.primitives.ThingGroupName(impl.thingGroupName())
    override val recursive: Optional[Recursive] = zio.aws.core.internal
      .optionalFromNullable(impl.recursive())
      .map(value => zio.aws.iot.model.primitives.Recursive(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[RegistryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest
  ): zio.aws.iot.model.ListThingsInThingGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
