package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListThingsResponse(
    things: Optional[Iterable[zio.aws.iot.model.ThingAttribute]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingsResponse = {
    import ListThingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingsResponse
      .builder()
      .optionallyWith(
        things.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.things)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingsResponse.ReadOnly =
    zio.aws.iot.model.ListThingsResponse.wrap(buildAwsValue())
}
object ListThingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingsResponse =
      zio.aws.iot.model.ListThingsResponse(
        things.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def things: Optional[List[zio.aws.iot.model.ThingAttribute.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getThings
        : ZIO[Any, AwsError, List[zio.aws.iot.model.ThingAttribute.ReadOnly]] =
      AwsError.unwrapOptionField("things", things)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingsResponse
  ) extends zio.aws.iot.model.ListThingsResponse.ReadOnly {
    override val things
        : Optional[List[zio.aws.iot.model.ThingAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.things())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.ThingAttribute.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingsResponse
  ): zio.aws.iot.model.ListThingsResponse.ReadOnly = new Wrapper(impl)
}
