package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTopicRuleDestinationsResponse(
    destinationSummaries: Optional[
      Iterable[zio.aws.iot.model.TopicRuleDestinationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse = {
    import ListTopicRuleDestinationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse
      .builder()
      .optionallyWith(
        destinationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListTopicRuleDestinationsResponse.ReadOnly =
    zio.aws.iot.model.ListTopicRuleDestinationsResponse.wrap(buildAwsValue())
}
object ListTopicRuleDestinationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListTopicRuleDestinationsResponse =
      zio.aws.iot.model.ListTopicRuleDestinationsResponse(
        destinationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def destinationSummaries
        : Optional[List[zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDestinationSummaries: ZIO[Any, AwsError, List[
      zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("destinationSummaries", destinationSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse
  ) extends zio.aws.iot.model.ListTopicRuleDestinationsResponse.ReadOnly {
    override val destinationSummaries: Optional[
      List[zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.TopicRuleDestinationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse
  ): zio.aws.iot.model.ListTopicRuleDestinationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
