package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTopicRulesResponse(
    rules: Optional[Iterable[zio.aws.iot.model.TopicRuleListItem]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListTopicRulesResponse = {
    import ListTopicRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListTopicRulesResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListTopicRulesResponse.ReadOnly =
    zio.aws.iot.model.ListTopicRulesResponse.wrap(buildAwsValue())
}
object ListTopicRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListTopicRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListTopicRulesResponse =
      zio.aws.iot.model.ListTopicRulesResponse(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def rules: Optional[List[zio.aws.iot.model.TopicRuleListItem.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.iot.model.TopicRuleListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRulesResponse
  ) extends zio.aws.iot.model.ListTopicRulesResponse.ReadOnly {
    override val rules
        : Optional[List[zio.aws.iot.model.TopicRuleListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.TopicRuleListItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRulesResponse
  ): zio.aws.iot.model.ListTopicRulesResponse.ReadOnly = new Wrapper(impl)
}
