package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait LogLevel {
  def unwrap: software.amazon.awssdk.services.iot.model.LogLevel
}
object LogLevel {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.LogLevel
  ): zio.aws.iot.model.LogLevel = value match {
    case software.amazon.awssdk.services.iot.model.LogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.LogLevel.DEBUG =>
      val r = DEBUG
      r
    case software.amazon.awssdk.services.iot.model.LogLevel.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.iot.model.LogLevel.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.iot.model.LogLevel.WARN =>
      val r = WARN
      r
    case software.amazon.awssdk.services.iot.model.LogLevel.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.LogLevel {
    override def unwrap: software.amazon.awssdk.services.iot.model.LogLevel =
      software.amazon.awssdk.services.iot.model.LogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object DEBUG extends zio.aws.iot.model.LogLevel {
    override def unwrap: software.amazon.awssdk.services.iot.model.LogLevel =
      software.amazon.awssdk.services.iot.model.LogLevel.DEBUG
  }
  case object INFO extends zio.aws.iot.model.LogLevel {
    override def unwrap: software.amazon.awssdk.services.iot.model.LogLevel =
      software.amazon.awssdk.services.iot.model.LogLevel.INFO
  }
  case object ERROR extends zio.aws.iot.model.LogLevel {
    override def unwrap: software.amazon.awssdk.services.iot.model.LogLevel =
      software.amazon.awssdk.services.iot.model.LogLevel.ERROR
  }
  case object WARN extends zio.aws.iot.model.LogLevel {
    override def unwrap: software.amazon.awssdk.services.iot.model.LogLevel =
      software.amazon.awssdk.services.iot.model.LogLevel.WARN
  }
  case object DISABLED extends zio.aws.iot.model.LogLevel {
    override def unwrap: software.amazon.awssdk.services.iot.model.LogLevel =
      software.amazon.awssdk.services.iot.model.LogLevel.DISABLED
  }
}
