package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.LogTargetName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LogTarget(
    targetType: zio.aws.iot.model.LogTargetType,
    targetName: Optional[LogTargetName] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.LogTarget = {
    import LogTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.LogTarget
      .builder()
      .targetType(targetType.unwrap)
      .optionallyWith(
        targetName.map(value => LogTargetName.unwrap(value): java.lang.String)
      )(_.targetName)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.LogTarget.ReadOnly =
    zio.aws.iot.model.LogTarget.wrap(buildAwsValue())
}
object LogTarget {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.LogTarget] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.LogTarget =
      zio.aws.iot.model.LogTarget(targetType, targetName.map(value => value))
    def targetType: zio.aws.iot.model.LogTargetType
    def targetName: Optional[LogTargetName]
    def getTargetType: ZIO[Any, Nothing, zio.aws.iot.model.LogTargetType] =
      ZIO.succeed(targetType)
    def getTargetName: ZIO[Any, AwsError, LogTargetName] =
      AwsError.unwrapOptionField("targetName", targetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.LogTarget
  ) extends zio.aws.iot.model.LogTarget.ReadOnly {
    override val targetType: zio.aws.iot.model.LogTargetType =
      zio.aws.iot.model.LogTargetType.wrap(impl.targetType())
    override val targetName: Optional[LogTargetName] = zio.aws.core.internal
      .optionalFromNullable(impl.targetName())
      .map(value => zio.aws.iot.model.primitives.LogTargetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.LogTarget
  ): zio.aws.iot.model.LogTarget.ReadOnly = new Wrapper(impl)
}
