package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LogTargetConfiguration(
    logTarget: Optional[zio.aws.iot.model.LogTarget] = Optional.Absent,
    logLevel: Optional[zio.aws.iot.model.LogLevel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.LogTargetConfiguration = {
    import LogTargetConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.LogTargetConfiguration
      .builder()
      .optionallyWith(logTarget.map(value => value.buildAwsValue()))(
        _.logTarget
      )
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.LogTargetConfiguration.ReadOnly =
    zio.aws.iot.model.LogTargetConfiguration.wrap(buildAwsValue())
}
object LogTargetConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.LogTargetConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.LogTargetConfiguration =
      zio.aws.iot.model.LogTargetConfiguration(
        logTarget.map(value => value.asEditable),
        logLevel.map(value => value)
      )
    def logTarget: Optional[zio.aws.iot.model.LogTarget.ReadOnly]
    def logLevel: Optional[zio.aws.iot.model.LogLevel]
    def getLogTarget: ZIO[Any, AwsError, zio.aws.iot.model.LogTarget.ReadOnly] =
      AwsError.unwrapOptionField("logTarget", logTarget)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.iot.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.LogTargetConfiguration
  ) extends zio.aws.iot.model.LogTargetConfiguration.ReadOnly {
    override val logTarget: Optional[zio.aws.iot.model.LogTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logTarget())
        .map(value => zio.aws.iot.model.LogTarget.wrap(value))
    override val logLevel: Optional[zio.aws.iot.model.LogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logLevel())
        .map(value => zio.aws.iot.model.LogLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.LogTargetConfiguration
  ): zio.aws.iot.model.LogTargetConfiguration.ReadOnly = new Wrapper(impl)
}
