package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait LogTargetType {
  def unwrap: software.amazon.awssdk.services.iot.model.LogTargetType
}
object LogTargetType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.LogTargetType
  ): zio.aws.iot.model.LogTargetType = value match {
    case software.amazon.awssdk.services.iot.model.LogTargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.LogTargetType.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.iot.model.LogTargetType.THING_GROUP =>
      val r = THING_GROUP
      r
    case software.amazon.awssdk.services.iot.model.LogTargetType.CLIENT_ID =>
      val r = CLIENT_ID
      r
    case software.amazon.awssdk.services.iot.model.LogTargetType.SOURCE_IP =>
      val r = SOURCE_IP
      r
    case software.amazon.awssdk.services.iot.model.LogTargetType.PRINCIPAL_ID =>
      val r = PRINCIPAL_ID
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.LogTargetType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.LogTargetType =
      software.amazon.awssdk.services.iot.model.LogTargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT extends zio.aws.iot.model.LogTargetType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.LogTargetType =
      software.amazon.awssdk.services.iot.model.LogTargetType.DEFAULT
  }
  case object THING_GROUP extends zio.aws.iot.model.LogTargetType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.LogTargetType =
      software.amazon.awssdk.services.iot.model.LogTargetType.THING_GROUP
  }
  case object CLIENT_ID extends zio.aws.iot.model.LogTargetType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.LogTargetType =
      software.amazon.awssdk.services.iot.model.LogTargetType.CLIENT_ID
  }
  case object SOURCE_IP extends zio.aws.iot.model.LogTargetType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.LogTargetType =
      software.amazon.awssdk.services.iot.model.LogTargetType.SOURCE_IP
  }
  case object PRINCIPAL_ID extends zio.aws.iot.model.LogTargetType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.LogTargetType =
      software.amazon.awssdk.services.iot.model.LogTargetType.PRINCIPAL_ID
  }
}
