package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  JobTemplateArn,
  ManagedJobTemplateName,
  Environment,
  JobDescription,
  ManagedTemplateVersion
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ManagedJobTemplateSummary(
    templateArn: Optional[JobTemplateArn] = Optional.Absent,
    templateName: Optional[ManagedJobTemplateName] = Optional.Absent,
    description: Optional[JobDescription] = Optional.Absent,
    environments: Optional[Iterable[Environment]] = Optional.Absent,
    templateVersion: Optional[ManagedTemplateVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary = {
    import ManagedJobTemplateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary
      .builder()
      .optionallyWith(
        templateArn.map(value => JobTemplateArn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .optionallyWith(
        templateName.map(value =>
          ManagedJobTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environments.map(value =>
          value.map { item =>
            Environment.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.environments)
      .optionallyWith(
        templateVersion.map(value =>
          ManagedTemplateVersion.unwrap(value): java.lang.String
        )
      )(_.templateVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ManagedJobTemplateSummary.ReadOnly =
    zio.aws.iot.model.ManagedJobTemplateSummary.wrap(buildAwsValue())
}
object ManagedJobTemplateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ManagedJobTemplateSummary =
      zio.aws.iot.model.ManagedJobTemplateSummary(
        templateArn.map(value => value),
        templateName.map(value => value),
        description.map(value => value),
        environments.map(value => value),
        templateVersion.map(value => value)
      )
    def templateArn: Optional[JobTemplateArn]
    def templateName: Optional[ManagedJobTemplateName]
    def description: Optional[JobDescription]
    def environments: Optional[List[Environment]]
    def templateVersion: Optional[ManagedTemplateVersion]
    def getTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getTemplateName: ZIO[Any, AwsError, ManagedJobTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironments: ZIO[Any, AwsError, List[Environment]] =
      AwsError.unwrapOptionField("environments", environments)
    def getTemplateVersion: ZIO[Any, AwsError, ManagedTemplateVersion] =
      AwsError.unwrapOptionField("templateVersion", templateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary
  ) extends zio.aws.iot.model.ManagedJobTemplateSummary.ReadOnly {
    override val templateArn: Optional[JobTemplateArn] = zio.aws.core.internal
      .optionalFromNullable(impl.templateArn())
      .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val templateName: Optional[ManagedJobTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value =>
          zio.aws.iot.model.primitives.ManagedJobTemplateName(value)
        )
    override val description: Optional[JobDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val environments: Optional[List[Environment]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.Environment(item)
          }.toList
        )
    override val templateVersion: Optional[ManagedTemplateVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateVersion())
        .map(value =>
          zio.aws.iot.model.primitives.ManagedTemplateVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary
  ): zio.aws.iot.model.ManagedJobTemplateSummary.ReadOnly = new Wrapper(impl)
}
