package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait MessageFormat {
  def unwrap: software.amazon.awssdk.services.iot.model.MessageFormat
}
object MessageFormat {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.MessageFormat
  ): zio.aws.iot.model.MessageFormat = value match {
    case software.amazon.awssdk.services.iot.model.MessageFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.MessageFormat.RAW =>
      val r = RAW
      r
    case software.amazon.awssdk.services.iot.model.MessageFormat.JSON =>
      val r = JSON
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.MessageFormat {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.MessageFormat =
      software.amazon.awssdk.services.iot.model.MessageFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object RAW extends zio.aws.iot.model.MessageFormat {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.MessageFormat =
      software.amazon.awssdk.services.iot.model.MessageFormat.RAW
  }
  case object JSON extends zio.aws.iot.model.MessageFormat {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.MessageFormat =
      software.amazon.awssdk.services.iot.model.MessageFormat.JSON
  }
}
